//
//  OPDocumentAttributes.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-07-21.
//
//

#import <Foundation/Foundation.h>

/*
 Filename : The name of the file that this document represents. (e.g. 'Hamburgler.png')
 UTI : The universal type identifier of the unencrypted data. (e.g. 'public.image') This could be used to automatically choose an appropriate icon for the item.
 Unencrypted Size : The number of bytes that the unencrypted file would consume on disk. This would be the size that should be shown to the user if ever it should be shown.
 Encrypted Size : The number of bytes that the encrypted file would consume on disk. This number can be useful to determine if the user has sufficient disk space to download and open the file. They'll need enough space to have both the Encrypted and Unencrypted version of the file on disk at the same time.
 Integrity Hash : The Base64 Encoded SHA256 of the encrypted data. This can be used to validate the download of a file to make sure that it matches what was expected. To test the value, you can run this command: cat FILENAME.js | openssl dgst -sha256 -binary | openssl enc -base64 -A. This is based on the SRI Hash.
 Identifier : The identifier generated by the server for the uploaded file.
 Encryption Key : The symmetric key used to encrypt the file contents, in JSON Web Key format, with decrypted key. Since this data will be encrypted as part of the item, we do not need to protect this key. The encryption key should be of type A256GCM, which is the same key type used for vault keys.
 Nonce : A cryptographic number used in the encryption/decryption of the data
 */

@class B5MutableDocumentAttributes;
@class OPSymmetricKey;
@class OPAESKey;
@class B5Profile;

@interface B5DocumentAttributes : NSObject
@property (readonly, nonatomic) NSString *fileName;
@property (readonly, nonatomic) NSString *documentId;
@property (readonly, nonatomic) NSString *uti;
@property (readonly, nonatomic) uint64_t unencryptedSize;
@property (readonly, nonatomic) uint64_t encryptedSize;
@property (readonly, nonatomic) NSString *integrityHash;
@property (readonly, nonatomic) OPSymmetricKey *key;
@property (readonly, nonatomic) NSData *nonce;
@property (readonly, nonatomic) OPSymmetricKey *signingKey;

- (BOOL)isUploadComplete; // Document attributes has post-upload data (documentId) from upload
- (BOOL)hasFileReferenceSigningKey;

- (B5MutableDocumentAttributes *)mutableCopy;
- (B5DocumentAttributes *)copy;

+ (B5DocumentAttributes*)attributesFromJSON:(NSDictionary *)json;
- (NSDictionary *)JSONValue;

// Encrypted Attributes
- (NSData *)encryptedAttributesWithProfile:(B5Profile *)profile;
+ (B5DocumentAttributes *)attributesFromEncryptedData:(NSData *)data profile:(B5Profile *)profile;

@end

@interface B5MutableDocumentAttributes : B5DocumentAttributes
@property (readwrite, nonatomic) NSString *fileName;
@property (readwrite, nonatomic) NSString *documentId;
@property (readwrite, nonatomic) NSString *uti;
@property (readwrite, nonatomic) uint64_t unencryptedSize;
@property (readwrite, nonatomic) uint64_t encryptedSize;
@property (readwrite, nonatomic) NSString *integrityHash;
@property (readwrite, nonatomic) OPSymmetricKey *key;
@property (readwrite, nonatomic) NSData *nonce;
@property (readwrite, nonatomic) OPSymmetricKey *signingKey;
@end